// // // // // // // // // // // // //
//
//	Ebene.cc
//
//	erstellt 27.12.97 von Andreas Warnke
//	geändert 3.1.98 von Andreas Warnke
//



// // // // // // // // // // // // //
//
//	include
//

#include <View.h>
#include <Bitmap.h>
#include "Ebene.h"
#include "Karte.h"
#include "ConnectionStatus.h"
#include "AsciiKette.h"
#include "Objekt.h"
#include "ObjectBitmap.h"
#include "Definitions.h"



// // // // // // // // // // // // //
//
//	Konstruktor:
//

Ebene :: Ebene ( 
	BRect inRect,
	const char * inName,
	const char * inPassword )
	: BView (
		inRect,
		"Ebenen-View",
		B_FOLLOW_ALL_SIDES,
		B_WILL_DRAW | B_PULSE_NEEDED | B_FRAME_EVENTS )	//	FrameEvents for adjustment of scrollbars
{
	//	Scroller:
	DerScroller = NULL;
	
	//	View-Color:
	SetViewColor ( 0xff, 0xee, 0xd7 );
	
	//	Karte:
	DieWelt = NULL;
	
	//	MAusposition:
	MausX = -1;
	MausY = 0;
	DragMap = false;
	AutoScroll = false;
		
	//	Name und Passwort:
	DerName = Concat ( inName, NULL );
	DasPasswort = Concat ( inPassword, NULL );
	
	//	Auto-Scroll zur Startposition:
	ScrollToStartPosition = true;
};



// // // // // // // // // // // // //
//
//	Destruktor:
//

Ebene :: ~Ebene ()
{
	//	Variablen auf Dummy-Werete Setzen:
	DerScroller = NULL;
	
	if ( DieWelt != NULL )
	{
		//	DieKarte existiert.
		
		//	Karte löschen:
		delete DieWelt;
		DieWelt = NULL;
	};
	
	//	Name und PAssowrt löschen:
	if ( DerName != NULL )
	{
		delete [] DerName;
		DerName = NULL;
	};
	if ( DasPasswort != NULL )
	{
		delete [] DasPasswort;
		DasPasswort = NULL;
	};	
};



// // // // // // // // // // // // //
//
//	Initialisierung des Scrollers:
//

void Ebene :: InitScroller ( BScrollView * inView )
{
	//	Wert zuweisen:
	DerScroller = inView;
	
	//	Scroller einstellen:
	AdjustScrollBars();
};



// // // // // // // // // // // // //
//
//	Fenstergröße geändert:
//

void Ebene :: FrameResized ( float inWidth, float inHeight )
{
	//	Standard-Procedure:
	inherited :: FrameResized ( inWidth, inHeight);
	
	//	Scrollbars:
	AdjustScrollBars();
};


	
// // // // // // // // // // // // //
//
//	AdjustScrollBars:
//

void Ebene :: AdjustScrollBars ()
{
	//	Gibts nen Scroller?
	if ( DerScroller == NULL )
		return;
		
	//	Breite und Höhe des Frames:
	Window() -> Lock();	//	das ist OK, auch wenn Looper schon gelockt.		
	BRect DerFrame = Frame();
	float inWidth = DerFrame . right - DerFrame . left;
	float inHeight = DerFrame . bottom - DerFrame . top;
		
	//	Ermittle Scrollbars:
	BScrollBar * H_Bar = DerScroller -> ScrollBar ( B_HORIZONTAL );
	BScrollBar * V_Bar = DerScroller -> ScrollBar ( B_VERTICAL );
		
	if ( DieWelt == NULL )
	{
		//	keine Karte.
		if ( H_Bar != NULL )
			H_Bar -> SetRange ( 0.0, 0.0);
		if ( V_Bar != NULL )
			V_Bar -> SetRange ( 0.0, 0.0);
	}
	else
	{
		//	Karte existiert.
		float max_x = 2 * _Ebene_h_Karten_Rand
			+ ( DieWelt -> GetHeight() + 0.25 ) * _Ebene_h_Waben_dy
			- inHeight;
		if ( max_x < 0.0 )
			max_x = 0.0;
		float max_y = 2 * _Ebene_h_Karten_Rand
			+ ( DieWelt -> GetWidth() + 0.5 ) * _Ebene_h_Waben_Breite
			- inWidth;
		if ( max_y < 0.0 )
			max_y = 0.0;
		if ( H_Bar != NULL )
		{
			H_Bar -> SetRange ( 0.0, max_y);
			H_Bar -> SetSteps ( _Ebene_h_Waben_dy, 4 * _Ebene_h_Waben_dy);
			H_Bar -> SetProportion ( inWidth / (max_y + inWidth) );
		};
		if ( V_Bar != NULL )
		{
			V_Bar -> SetRange ( 0.0, max_x);
			V_Bar -> SetSteps ( _Ebene_h_Waben_Breite, 4 * _Ebene_h_Waben_Breite);
			V_Bar -> SetProportion ( inHeight / (max_x + inHeight) );
		};
	};
	
	//	Fertig mit malen.
	Window() -> Unlock();
};



// // // // // // // // // // // // //
//
//	GetBPoint:
//

BPoint Ebene :: GetBPoint ( int inXCoord, int inYCoord )
{
	return BPoint(
		_Ebene_h_Karten_Rand
			+ inXCoord * _Ebene_h_Waben_Breite 
			+ ( int( ( inYCoord & 1 ) == 0 ) * _Ebene_h_Waben_Breite ) / 2,
		_Ebene_h_Karten_Rand + inYCoord * _Ebene_h_Waben_dy );
};



// // // // // // // // // // // // //
//
//	GetBRect:
//

BRect Ebene :: GetBRect ( int inXCoord, int inYCoord )
{
	BRect Erg;
	Erg . left = _Ebene_h_Karten_Rand
		+ inXCoord * _Ebene_h_Waben_Breite 
		+ ( int( ( inYCoord & 1 ) == 0 ) * _Ebene_h_Waben_Breite ) / 2;
	Erg . top = _Ebene_h_Karten_Rand + inYCoord * _Ebene_h_Waben_dy;
	Erg . right = Erg . left + _Ebene_h_Waben_Breite - 1;
	Erg . bottom = Erg . top + _Ebene_h_Waben_Hoehe  - 1;
	return Erg;
};



// // // // // // // // // // // // //
//
//	GetMapLocation:
//

void Ebene :: GetMapLocation ( float inX, float inY, int & outX, int & outY )
{
	//	Rand abziehen.
	inX = inX - _Ebene_h_Karten_Rand;
	inY = inY - _Ebene_h_Karten_Rand;
	
	//	Zeile berechnen, Annahme: Rechteckige Waben:
	if ( inY < 0 )
		outY = inY / _Ebene_h_Waben_dy - 1;
	else
		outY = inY / _Ebene_h_Waben_dy;
	inY = inY - ( outY * _Ebene_h_Waben_dy );
	
	//	Spalte berechnen, Annahme: Rechteckige Waben:
	if ( ( outY & 1 ) == 0 )
		inX = inX - ( _Ebene_h_Waben_Breite / 2);
	if ( inX < 0 )
		outX = inX / _Ebene_h_Waben_Breite - 1;
	else
		outX = inX / _Ebene_h_Waben_Breite;
	inX = inX - ( outX * _Ebene_h_Waben_Breite );
	
	//	Ist Punkt im Dreieck oben links?
	inX = inX / _Ebene_h_Waben_Faktor;	//	=> inX e [0,2*Kantenlänge]
	inY = inY * 2;	// inY e [0,4*Kantenlänge]
	if ( inX + inY < _Ebene_h_Waben_Hoehe / 2 )
	{
		outY --;
		//	Falsche Koordinate berechnet.
		if ( ( outY & 1 ) == 0 )
			outX --;
	}
	//	Ist Punkt im Dreieck oben rechts?
	else if ( _Ebene_h_Waben_Hoehe - inX + inY < _Ebene_h_Waben_Hoehe / 2 )
	{
		//	Falsche Koordinate berechnet.
		if ( ( outY & 1 ) == 0 )
			outX ++;
		outY --;
	};
};



// // // // // // // // // // // // //
//
//	DrawField:
//

void Ebene :: DrawField ( int inXCoord, int inYCoord )
{
	if ( DieWelt == NULL )
		//	Welt existiert nicht.
		return;

	//	Berechne die Position des zu maldenden Feldes.
	BPoint LeftTop = GetBPoint( inXCoord, inYCoord );
	BRect Rahmen = Bounds();
	
	//	Überprüfe, ob das Feld überhaupt sichtbar ist:
	if ( ( LeftTop . x > Rahmen . right )
		|| ( LeftTop . y > Rahmen . bottom )
		|| ( LeftTop . x + _Ebene_h_Waben_Breite <= Rahmen . left )
		|| ( LeftTop . y + _Ebene_h_Waben_Hoehe <= Rahmen . top ))
		return;
		
	//	Transparente Pixel berücksichtigen!
	SetDrawingMode ( B_OP_OVER );

	//	Male Wabe:
	BBitmap* DasIcon = ObjectBitmap :: GetWabe ( DieWelt -> GetFieldType( inXCoord, inYCoord ) );
	if ( DasIcon != NULL )
		DrawBitmap( DasIcon, LeftTop );
		
	//	Highlight der Wabe?
	if ( ( inXCoord == MausX ) && ( inYCoord == MausY ) )
	{
		//	Transparente Pixel berücksichtigen!
		SetDrawingMode ( B_OP_ADD );
		DasIcon = ObjectBitmap :: GetWabe ( FT_HighlightWabe );
		if ( DasIcon != NULL )
			DrawBitmap( DasIcon, LeftTop );	
		//	Transparente Pixel berücksichtigen!
		SetDrawingMode ( B_OP_OVER );
	};
		
	//	Male Figuren:
	unsigned int Typ, Spieler, Anzahl;
	bool sBusy;
	DieWelt -> GetObjects ( inXCoord, inYCoord, Typ, Spieler, Anzahl, sBusy); 
	if ( sBusy )
		Typ = Typ | Obj_BusyMask ;
	DasIcon = ObjectBitmap :: GetBitmap ( Typ, Spieler, Anzahl);
	LeftTop . x = LeftTop . x + _Ebene_h_Objekt_Rand_X;
	LeftTop . y = LeftTop . y + _Ebene_h_Objekt_Rand_Y; 
	if ( DasIcon != NULL )
		DrawBitmap( DasIcon, LeftTop );	
};



// // // // // // // // // // // // //
//
//	GetObjects:
//
/*
struct GO_Params
{
	int inX;
	int inY;
	unsigned int outTyp;
	unsigned int outSpieler;
	unsigned int outAnzahl;
};

bool GetObjects_SearchOnField ( Objekt * inObjekt, GO_Params * ioParameters );
bool GetObjects_SearchOnField ( Objekt * inObjekt, GO_Params * ioParameters )
{
	if ( ( inObjekt -> XPos == ioParameters -> inX )
		&& ( inObjekt -> YPos == ioParameters -> inY ) )
	{
		if ( ioParameters -> outTyp == Obj_NoObject )
			ioParameters -> outTyp = inObjekt -> Typ;
		else if ( ioParameters -> outTyp != inObjekt -> Typ )
			ioParameters -> outTyp = Obj_Mixed;
		ioParameters -> outSpieler = inObjekt -> BelongsTo;
		ioParameters -> outAnzahl ++;
	};
	return false;
};*/



// // // // // // // // // // // // //
//
//	Draw:
//

void Ebene :: Draw ( BRect inRect )
{
	//	Existiert die Karte?
	if ( DieWelt == NULL )
	{
		MovePenTo (
			_Ebene_h_Karten_Rand + 0.5 * _Ebene_h_Waben_Breite + 1,
			_Ebene_h_Karten_Rand + 31 );
		DrawString ("Error: Not yet logged in.");
	}
	else
	{
		//	Transparente Pixel berücksichtigen!
		SetDrawingMode ( B_OP_OVER );
		
		//	Betroffene Bitmaps berechnen:
		const int width = DieWelt -> GetWidth();
		const int height = DieWelt -> GetHeight();
		
		int links = ( inRect.left - _Ebene_h_Karten_Rand ) / _Ebene_h_Waben_Breite - 0.5;
		if ( links >= width )
			links = width - 1;
		if ( links < 0 )
			links = 0;
		int rechts = ( inRect.right - _Ebene_h_Karten_Rand ) / _Ebene_h_Waben_Breite + 0.5;
		if ( rechts < 0 )
			rechts = 0;
		if ( rechts >= width )
			rechts = width - 1;
		int oben = ( inRect.top - _Ebene_h_Karten_Rand ) / _Ebene_h_Waben_dy - 1.0/3.0;
		if ( oben >= height )
			oben = height - 1;
		if ( oben < 0 )
			oben = 0;
		int unten = ( inRect.bottom - _Ebene_h_Karten_Rand ) / _Ebene_h_Waben_dy + 1.0/3.0;
		if ( unten < 0 )
			unten = 0;
		if ( unten >= height )
			unten = height - 1;
			
		//	Betroffene Bitmaps malen:
		for ( int x = links; x <= rechts; x++ )
			for ( int y = oben; y <= unten; y++ )
			{
				//	Malen:
				BPoint sViewPoint = GetBPoint(x,y);
				BBitmap* DasIcon = ObjectBitmap :: GetWabe ( DieWelt -> GetFieldType( x, y ) );
				if ( DasIcon != NULL )
					DrawBitmapAsync( DasIcon, sViewPoint );
			};
		Sync();
		
		//	Betroffene Objekte malen:
		
		for ( int x = links; x <= rechts; x++ )
			for ( int y = oben; y <= unten; y++ )
				if ( DieWelt -> CountObjects ( x, y ) > 0 )
				{
					//	Male Figuren:
					unsigned int Typ, Spieler, Anzahl;
					bool sBusy;
					DieWelt -> GetObjects ( x, y, Typ, Spieler, Anzahl, sBusy); 
					if ( sBusy )
						Typ = Typ | Obj_BusyMask;
					BBitmap* DasIcon3 = ObjectBitmap :: GetBitmap ( Typ, Spieler, Anzahl);
					BPoint LeftTop = GetBPoint(x,y);
					LeftTop . x = LeftTop . x + _Ebene_h_Objekt_Rand_X;
					LeftTop . y = LeftTop . y + _Ebene_h_Objekt_Rand_Y; 
					if ( DasIcon3 != NULL )
						DrawBitmapAsync( DasIcon3, LeftTop );
				};	
		Sync(); 
	};
};



// // // // // // // // // // // // //
//
//	ErrorAlert:
//

void Ebene :: ErrorAlert ( const char * inText )
{
	//	Alert ausgaben:
	BAlert * DerAlert = new BAlert (
		"Error",
		inText,
		"Hmm...");
	if ( DerAlert != NULL )
		DerAlert -> Go ( NULL );
};



// // // // // // // // // // // // //
//
//	MessageReceived:
//

void Ebene :: MessageReceived ( BMessage * inMessage )
{
	switch ( inMessage -> what )
	{
	case Msg_InterApplicationMessage:
		//	Message vom Server.
		
		//	Stimmt Passwort?
		if ( ! Equal ( inMessage -> FindString ( "Password" ), DasPasswort ) )
		{
			ErrorAlert ( "Message received, but wrong Password." );
			break;
		};
		
		//	Typ bestimmen:
		const char * DerTyp = inMessage -> FindString ( "Type" );
		
		if ( Equal ( DerTyp, "status" ) )
			//	Status korrigieren:
			GetStatus ( inMessage );
		else
		if ( Equal ( DerTyp, "error" ) )
			//	Fehler beim Server.
			ErrorAlert ( inMessage -> FindString ( "ErrorText" ) );
		else
		if ( Equal ( DerTyp, "welcome" ) )
			//	Initialisierung des Spiels:
			InitEbene ( inMessage );
		else
		if ( Equal ( DerTyp, "victory" ) )
		{
			//	Celebrate Victory:
			CelebrateVictory (
				inMessage -> FindInt32 ( "ID" ), 
				inMessage -> FindString ( "Name" ) );
		}
		else
			//	Fehler im Protokoll.
			ErrorAlert( "Message of unknown type received." );
		
		//	Fertig:
		break;
		
	case Msg_DragNDropMessage:
		//	Drag&Drop.
		if ( inMessage -> WasDropped() )
		{
			//	Drop-Position bestimmen:
			BPoint ThePoint = ConvertFromScreen( inMessage -> DropPoint() );
			int DropX;
			int DropY;
			GetMapLocation ( ThePoint . x, ThePoint . y, DropX, DropY);
			//	Objekt bewegen:
			if ( DieWelt != NULL )
			{
				//	DieWelt existiert.
				Objekt * sObj = DieWelt -> FindObject ( inMessage -> FindInt32( "ObjectID") );
				if ( sObj != NULL )
				if ( sObj -> BelongsTo == DieWelt -> DieID )
				{
					//	gedraggtes Objekt existiert in dieser Welt.
					if ( ( sObj -> XPos == DropX ) && ( sObj -> YPos == DropY ) )
						//	Move soll gecancelled werden.
						DieWelt -> MoveArmy (
							sObj -> GetID (),
							DropX,
							DropY );					
					DieWelt -> SetParadise ( sObj, DropX, DropY );
					if ( DieWelt -> SearchBestMove ( sObj ) )
					{
						//	Es gibt einen Weg.
						DieWelt -> MoveArmy (
							sObj -> GetID (),
							sObj -> MoveToX,
							sObj -> MoveToY );
					};
				};
			};
		};
		
		//	Fertig:
		break;
		
	case Msg_FieldInfo:
		if ( DieWelt != NULL )
			DieWelt -> InfoWindow ( inMessage -> FindInt32 ("XPos"),
				inMessage -> FindInt32 ("YPos") );
		break;
		
	case Msg_Build:
		if ( eEnableBuildingCities )
			if ( DieWelt != NULL )
				DieWelt -> BuildVillage ( inMessage -> FindInt32 ("ObjectID") );
		break;
		
	default:
		//	Tja, keine Ahnung, was das für ne Message ist.		
		//	Vielleicht kann ja Papa was mit anfangen:
		inherited :: MessageReceived ( inMessage );		
	};	
};



// // // // // // // // // // // // //
//
//	Init:
//

void Ebene :: InitEbene ( BMessage * inMessage )
{
	//	Existiert Karte schon?
	if ( DieWelt != NULL )
		ErrorAlert ("2nd Login-Message received.");
	else
	{
		//	KArte existiert noch nicht.
		
		//	Karte initialisieren:
		DieWelt = new ClientWelt (
			( uint32 ( inMessage -> FindInt32 ("MapSize") + 1 ) ) / 2,
			inMessage -> FindInt32 ("ClientID"),
			this );
		
		//	Anzeige aktualisieren:
		Window() -> Lock();
		Invalidate ();
		/*Draw ( Bounds() );*/
		Window() -> Unlock();
				
		//	Absende-Team bestimmen:
		if ( DieWelt != NULL )
		{
			DieWelt -> ServerTeam = inMessage -> ReturnAddress();
			DieWelt -> DerName = Concat ( DerName, NULL );
			DieWelt -> DasPasswort = Concat ( DasPasswort, NULL );
		};
		
		//	Scrollbars der Karte anpassen:
		AdjustScrollBars();
	};
};



// // // // // // // // // // // // //
//
//	GetStatus:
//

void Ebene :: GetStatus ( BMessage * inMessage )
{
	//	Existiert Karte?
	if ( DieWelt == NULL )
		return;
		
	//	Auslesen der Server-Time:
	bigtime_t NewServerTime;
	if ( inMessage -> FindInt64 ( "CurrentTime", &NewServerTime ) >= B_NO_ERROR )
	{
		DieWelt -> ServerTime = NewServerTime;
		DieWelt -> EqualClientTime = real_time_clock_usecs ();
	};
	
	//	Liste aller up-zu-datenden Felder:
	enum { sMaxList = 24 };
	int sUpdateX [sMaxList];
	int sUpdateY [sMaxList];
	int sUpdate = sMaxList;
	
	//	included Messages:
	BMessage Found;
	
	//	Auslesen der Felder:
	int i = 0;
	while ( inMessage -> FindMessage ( "Field", i, &Found) >= B_NO_ERROR )
	{
		int x = Found . FindInt32( "XPos" );
		int y = Found . FindInt32( "YPos" );
		int sType = Found . FindInt32( "Type" );
		int oldType = DieWelt -> GetFieldType ( x, y);
		if ( sType == FT_Invisible )
		{
			//	Feld schattieren:
			if ( ( oldType != FT_Undiscovered ) && ( oldType != FT_EndOfWorld ))
				//	Dies ist ein schattierbares Feld.
				sType = oldType | FT_ShadowMask;
			else
				sType = oldType;
		};
		if ( ( oldType != sType ) || ( DieWelt -> GetSpielerID ( x, y ) != 0 ) )
		{
			//	Das Aussehen des Feldes oder der Figuren ändert sich:
			sUpdate--;
			if ( sUpdate >= 0 )
			{
				sUpdateX [sUpdate] = x;
				sUpdateY [sUpdate] = y;
			};
		};
		DieWelt -> SetFieldType ( x, y, sType );
		//	Lösche Objekte auf diesem Feld:
		DieWelt -> DeleteAtPos ( x, y );
		//	next message:
		i ++;
	};

	//	Auslesen der Objekte:
	i = 0;
	while ( inMessage -> FindMessage ( "Object", i, & Found) >= B_NO_ERROR )
	{
		//	BusyTill auslesen:
		bigtime_t BusyTill;
		if ( Found . FindInt64( "BusyTill", & BusyTill ) < B_NO_ERROR)
			BusyTill = DieWelt -> ServerTime;
		
		//	Owner bestimmen:
		int sOwner = Found . FindInt32( "Owner" );
		
		//	Typ bestimmen:
		int sTyp = Found . FindInt32( "Type" );
		if ( ( BusyTill > DieWelt -> ServerTime )
			/* && ( sOwner == DieWelt -> DieID ) */	//	nur meine Objekte werden gekennzeichnet.
			/* && ( sTyp == Obj_Figur )	 */ )	//	nur Figuren werden gekennzeichent.
			//	eigene Figur ist noch beschäftigt.
			sTyp = sTyp | Obj_BusyMask;
		
		//	Neues Objekt:
		int sThisX = Found . FindInt32( "XPos" );
		int sThisY = Found . FindInt32( "YPos" );
		Objekt * NeuObj = new Objekt (
			Found . FindInt32( "ID" ),
			sTyp,
			sOwner,
			sThisX,
			sThisY,
			BusyTill );
		
		//	in Liste einfügen:
		if ( NeuObj != NULL )
			if ( ! DieWelt -> Insert ( NeuObj ) )
				delete NeuObj;
				
		//	Das Feld in die Update-Liste aufnehmen:
		bool sUpdateUpdate = true;
		for ( int sUpdateRun = sUpdate; ( sUpdateRun < sMaxList ) && sUpdateUpdate; sUpdateRun ++ )
			if ( ( sUpdateX [sUpdateRun] == sThisX ) && ( sUpdateY [sUpdateRun] == sThisY ) )
				sUpdateUpdate = false;
		if ( sUpdateUpdate )
		{
			//	Das Feld ist noch nicht drinne:
			sUpdate --;
			if ( sUpdate >= 0 )
			{
				sUpdateX [sUpdate] = sThisX;
				sUpdateY [sUpdate] = sThisY;
			};
		};
				
		//	A* Suche nach kürzestem Weg zum Ziel:
		if ( DieWelt -> SearchBestMove ( NeuObj ) )
			DieWelt -> MoveArmy ( NeuObj -> GetID (), NeuObj -> MoveToX, NeuObj -> MoveToY );
		
		//	Autoscroll zur Startposition:
		if ( ScrollToStartPosition )
		{
			BRect sCViewBnds = Bounds();
			ScrollTo ( BPoint (
				( sThisX + 0.5 ) * _Ebene_h_Waben_Breite + _Ebene_h_Karten_Rand - sCViewBnds . Width () / 2,
				( sThisY + 0.5 ) * _Ebene_h_Waben_dy + _Ebene_h_Karten_Rand - sCViewBnds . Height () / 2 ) );
			ScrollToStartPosition = false;
		};
		
		//	naechste message:
		i ++;
	};
	
	//	Malen im Fenster vorbereiten:
	Window() -> Lock();
	if ( sUpdate < 0 )
		//	Die Liste ist übergelaufen.
		Draw ( Bounds () );
	else
		while ( sUpdate < sMaxList )
		{
			DrawField ( sUpdateX [sUpdate], sUpdateY [sUpdate] );
			sUpdate++;
		};
	Window() -> Unlock();
};



// // // // // // // // // // // // //
//
//	Pulse:
//

void Ebene :: Pulse ()
{
	//	Highlight Wabe:
	BPoint sMouseLocation;
	uint32 sMouseButtons;
	GetMouse ( & sMouseLocation, & sMouseButtons, false );
	MouseCursor ( sMouseLocation, NULL );
	
	//	DragMap:
	if ( DragMap )
	{
		if ( ( sMouseButtons & B_PRIMARY_MOUSE_BUTTON ) == 0 )
			//	MAus losgelassen.
			DragMap = NULL;
		else
		{
			//	Scrolling.
			BPoint sMaus = ConvertToScreen ( sMouseLocation );
			ScrollBy ( DragMapPos . x - sMaus . x, DragMapPos . y - sMaus . y );
			DragMapPos = sMaus;
		};
	};
	
	//	AutoScroll:
	if ( AutoScroll )
	{
		if ( ( sMouseButtons & B_PRIMARY_MOUSE_BUTTON ) == 0 )
			//	MAus losgelassen.
			AutoScroll = NULL;
		else
		{
			//	Scrolling.
			BRect sWinRect = Window () -> Frame ();
			BPoint sMaus2 = ConvertToScreen ( sMouseLocation );
			if ( sWinRect . Contains ( sMaus2 ) )
			{
				float sDx = 0.0;
				float sDy = 0.0;
				float sWidth = sWinRect . Width ();
				float sHeight = sWinRect . Height ();
				sMaus2 = sMaus2 - sWinRect . LeftTop ();
				float sXRel = 2.0 * sMaus2 . x / sWidth - 1.0;
				float sYRel = 2.0 * sMaus2 . y / sHeight - 1.0;
				BRect sNoScroll = sWinRect;
				sNoScroll . OffsetTo ( 0.0, 0.0 );
				sNoScroll . InsetBy ( _Ebene_h_Waben_Breite, _Ebene_h_Waben_Breite );
				float sAdd;
				bool sScroll = false;
				if ( sMaus2 . x < sNoScroll . left )
				{
					//	maus am linken rand.
					sAdd = ( sNoScroll . left - sMaus2 . x );
					sDx = sDx - sAdd;
					sDy = sDy + sYRel * sAdd;
					sScroll = true;
				};
				if ( sMaus2 . x > sNoScroll . right )
				{
					//	maus rechts.
					sAdd = ( sMaus2 . x - sNoScroll . right );
					sDx = sDx + sAdd;
					sDy = sDy + sYRel * sAdd;
					sScroll = true;
				};
				if ( sMaus2 . y > sNoScroll . bottom )
				{
					//	maus unten.
					sAdd = ( sMaus2 . y - sNoScroll . bottom );
					sDy = sDy + sAdd;
					sDx = sDx + sXRel * sAdd;
					sScroll = true;
				};
				if ( sMaus2 . y < sNoScroll . top )
				{
					//	maus unten.
					sAdd = ( sNoScroll . top - sMaus2 . y );
					sDy = sDy - sAdd;
					sDx = sDx + sXRel * sAdd;
					sScroll = true;
				};
				if ( sScroll )
					ScrollBy ( sDx, sDy );
			};
		};
	};
};



// // // // // // // // // // // // //
//
//	MouseDown:
//

void Ebene :: MouseDown ( BPoint inPos )
{
	//	Suche zu draggendes Objekt:
	Objekt * DragMeObj = NULL;
	if ( DieWelt != NULL )
		DragMeObj = DieWelt -> GetLatestArmy ( MausX, MausY);
	
	//	Welcher button ist gedrückt?
	uint32 sButton = Window () -> CurrentMessage () -> FindInt32 ( "buttons" );
	
	if ( ( ( sButton & B_PRIMARY_MOUSE_BUTTON ) != 0 )
		&&	( ( modifiers () & ( B_SHIFT_KEY | B_CONTROL_KEY | B_MENU_KEY | B_OPTION_KEY | B_COMMAND_KEY ) ) == 0 ) )
		//	Button 1 gedrückt.
		if ( DragMeObj != NULL )
		{
			//	Es gibt was zu draggen.
			BMessage DragMeMsg( Msg_DragNDropMessage );
	
			//	Füge Daten an die Message:
			DragMeMsg . AddInt32 ( "ObjectID", DragMeObj -> GetID () );
			
			//	Kopie der Bitmap:
			BBitmap * sOriginal = ObjectBitmap :: GetBitmap ( DragMeObj -> Typ, DragMeObj -> BelongsTo, 1);
			BBitmap * sKopie = NULL;
			if ( sOriginal != NULL )
			{
				sKopie = new BBitmap (
					sOriginal -> Bounds (),
					sOriginal -> ColorSpace (),
					false );
				if ( sKopie != NULL )
					memcpy ( sKopie -> Bits (), sOriginal -> Bits (), sKopie -> BitsLength() );
			};
			
			//	DragNDrop:
			DragMessage (
				& DragMeMsg,
				sKopie,
				inPos - GetBPoint( MausX, MausY) - BPoint ( _Ebene_h_Objekt_Rand_X, _Ebene_h_Objekt_Rand_Y));
				
			//	Schalte Auto-Scrolling ein:
			AutoScroll = true;
		}
		else
		{
			//	Maus auf leerem Feld gedrückt:
			DragMap = true;
			DragMapPos = ConvertToScreen ( inPos );
		}
	else
	{
		//	Button 2 oder 3 gedrückt.
		//	Erstelle BMenu
		unsigned int sBuildID = 0;
		if ( DragMeObj != NULL )
			sBuildID = DragMeObj -> GetID ();
		BPopUpMenu * sMenu = CreatePopUp ( MausX, MausY, sBuildID );
		if ( sMenu == NULL )
		{
			#ifdef ERROR
			ErrorAlert ("Out of memory in Ebene.cc/MouseDown/1");
			#endif
		}
		else
		{
			sMenu -> Go (
				ConvertToScreen ( inPos ),
				true,	//	deliver Message to Window
				false,	//	kein sticky menu!
				true );	//	asynchron
		};
	}
};



// // // // // // // // // // // // //
//
//	CreatePopUp:
//

BPopUpMenu * Ebene :: CreatePopUp ( int inInfoX, int inInfoY, unsigned int inBuildID )
{
	//	Erstelle PopUpMenu:
	BPopUpMenu * sMenu = new BPopUpMenu ("Build-Menu");
	if ( sMenu == NULL )
		return NULL;
		
	//	Erstelle "Build village"
	BMessage * sMenuMsg = NULL;
	BMenuItem * sItem = NULL;
	if ( eEnableBuildingCities )
	{
		if ( inBuildID != 0 )
		{
			sMenuMsg = new BMessage ( Msg_Build );
			if ( sMenuMsg != NULL )
				sMenuMsg -> AddInt32 ( "ObjectID", inBuildID );
		};
		sItem = new BMenuItem ("Build City", sMenuMsg );
		if ( sItem != NULL )
		{
			sItem -> SetEnabled ( sMenuMsg != NULL );
			sItem -> SetTarget ( this );
			sMenu -> AddItem ( sItem );
		}
		else if ( sMenuMsg != NULL )
			delete sMenuMsg;
	};
		
	//	Erstelle "GetInfo"
	sMenuMsg = NULL;
	if ( DieWelt != NULL )
	if ( DieWelt -> GetFieldType ( inInfoX, inInfoY ) != FT_EndOfWorld )
	{
		sMenuMsg = new BMessage ( Msg_FieldInfo );
		if ( sMenuMsg != NULL )
		{
			sMenuMsg -> AddInt32 ( "XPos", inInfoX );
			sMenuMsg -> AddInt32 ( "YPos", inInfoY );
		};
	};
	sItem = new BMenuItem ("Get Info", sMenuMsg );
	if ( sItem != NULL )
	{
		sItem -> SetEnabled ( sMenuMsg != NULL );
		sItem -> SetTarget ( this );
		sMenu -> AddItem ( sItem );
	}
	else if ( sMenuMsg != NULL )
		delete sMenuMsg;
		
	//	Sepatator:
	sMenu -> AddSeparatorItem ();
	
	//	Erstelle "About Fastattack"
	sItem = new BMenuItem ("About Enemy Territory", new BMessage ( B_ABOUT_REQUESTED ) );
	if ( sItem != NULL )
	{
		sItem -> SetTarget ( be_app );
		sMenu -> AddItem ( sItem );
	};
		
	//	Erstelle "Login"
	sItem = new BMenuItem ("Login", new BMessage ( Msg_Login ) );
	if ( sItem != NULL )
	{
		sItem -> SetTarget ( be_app );
		sMenu -> AddItem ( sItem );
	};
		
	//	Erstelle "Resize Window"
	sItem = new BMenuItem ("Resize Window", new BMessage ( Msg_Zoom ) );
	if ( sItem != NULL )
	{
		sItem -> SetTarget ( Window () );
		sMenu -> AddItem ( sItem );
	};
		
	//	Erstelle "Minimize Window"
	sItem = new BMenuItem ("Minimize Window", new BMessage ( Msg_Minimize ) );
	if ( sItem != NULL )
	{
		sItem -> SetTarget ( Window () );
		sMenu -> AddItem ( sItem );
	};
		
	//	Erstelle "Close Window"
	sItem = new BMenuItem ("Close Window", new BMessage ( Msg_Close ) );
	if ( sItem != NULL )
	{
		sItem -> SetTarget ( Window () );
		sMenu -> AddItem ( sItem );
	};
		
	//	Erstelle "Quit Application"
	sItem = new BMenuItem ("Quit Application", new BMessage ( B_QUIT_REQUESTED ) );
	if ( sItem != NULL )
	{
		sItem -> SetTarget ( be_app );
		sMenu -> AddItem ( sItem );
	};
			
	//	Fertig:
	return sMenu;
};



// // // // // // // // // // // // //
//
//	Scrollby:
//

void Ebene :: ScrollBy ( float inDx, float inDy )
{
	if ( DieWelt != NULL )
	{
		BRect sRect = Bounds ();
		float sBottom = 2 * _Ebene_h_Karten_Rand
			+ ( DieWelt -> GetHeight() + 0.25 ) * _Ebene_h_Waben_dy;
		if ( sBottom < 0.0 )
			sBottom = 0.0;
		float sRight = 2 * _Ebene_h_Karten_Rand
			+ ( DieWelt -> GetWidth() + 0.5 ) * _Ebene_h_Waben_Breite;
		if ( sRight < 0.0 )
			sRight = 0.0;
		if ( sRect . right + inDx > sRight )
			inDx = sRight - sRect . right;
		if ( sRect . bottom + inDy > sBottom )
			inDy = sBottom - sRect . bottom;
		if ( sRect . left + inDx < 0.0 )
			inDx = - sRect . left;
		if ( sRect . top + inDy < 0.0 )
			inDy = - sRect . top;
		inherited :: ScrollBy ( inDx, inDy );
	};
};

void Ebene :: ScrollTo ( BPoint inLeftTop )
{
	if ( DieWelt != NULL )
	{
		BRect sRect = Bounds ();
		float sBottom = 2 * _Ebene_h_Karten_Rand
			+ ( DieWelt -> GetHeight() + 0.25 ) * _Ebene_h_Waben_dy;
		if ( sBottom < 0.0 )
			sBottom = 0.0;
		float sRight = 2 * _Ebene_h_Karten_Rand
			+ ( DieWelt -> GetWidth() + 0.5 ) * _Ebene_h_Waben_Breite;
		if ( sRight < 0.0 )
			sRight = 0.0;
		if ( inLeftTop . x > sRight )
			inLeftTop . x = sRect . right;
		if ( inLeftTop . y > sBottom )
			inLeftTop . y = sRect . bottom;
		if ( inLeftTop . x < 0.0 )
			inLeftTop . x = 0.0;
		if ( inLeftTop . y < 0.0 )
			inLeftTop . y = 0.0;
		inherited :: ScrollTo ( inLeftTop );
	};
};



// // // // // // // // // // // // //
//
//	MouseMoved:
//

void Ebene :: MouseMoved(
	BPoint inLocation,
	uint32 inAction,
	const BMessage * inMessage)
{
	/* MouseCursor ( inLocation, inMessage ); */
};



// // // // // // // // // // // // //
//
//	MouseCursor:
//

void Ebene :: MouseCursor (
	BPoint inLocation,
	const BMessage * inMessage)
{
	//	Fehler?
	if ( DieWelt == NULL)
		return;
		
	//	Bestimme, ob maus in View:
	BRegion sTester;
	GetClippingRegion ( & sTester );
	bool sDrinne = sTester . Contains ( inLocation );
		
	if ( ( ( MausX < 0 ) || ( MausY < 0 ) ) && ( ! sDrinne ) )
		//	Maus war und ist draußen.
		return;
		
	if ( sDrinne && ( MausX >= 0 ) && ( MausY >= 0 ) )
	{
		//	Maus war und ist drinne.
		int X = MausX;
		int Y = MausY;
		GetMapLocation ( inLocation . x, inLocation . y, MausX, MausY );
		if ( inMessage != NULL) if ( inMessage -> what != Msg_DragNDropMessage )
			//	Das Drag-Objekt ist keine armee.
			MausX = -1;
		if ( ( X != MausX ) || ( Y != MausY ) )
		{
			if ( DieWelt -> GetFieldType ( X, Y) != FT_EndOfWorld )
				DrawField( X, Y);
			if ( DieWelt -> GetFieldType ( MausX, MausY) != FT_EndOfWorld )
				DrawField( MausX, MausY);
		};
	}
	else if ( sDrinne )
	{
		//	Mouse entered view.
		GetMapLocation ( inLocation . x, inLocation . y, MausX, MausY);
		if ( inMessage != NULL) if ( inMessage -> what != Msg_DragNDropMessage )
			MausX = -1;
		if ( DieWelt -> GetFieldType ( MausX, MausY) != FT_EndOfWorld )
			DrawField( MausX, MausY);		
	}
	else
	{
		//	Mouse exited view.
		int X1 = MausX;
		int Y1 = MausY;
		MausX = -1;
		if ( DieWelt -> GetFieldType ( X1, Y1) != FT_EndOfWorld )
			DrawField( X1, Y1);				
	};
};



// // // // // // // // // // // // //
//
//	CelebrateVictory
//

void Ebene :: CelebrateVictory ( unsigned int inID, const char * inName )
{
	//	Parametercheck:
	if ( Window () == NULL )
		return;
		
	if ( ( Window () -> IsActive () ) && Equal ( inName, DerName ) )
	{
		//	Dies ist der Sieger-Thread!
		char * sAnzeige = Concat ( 
			"Victory! The winner is ",
			inName,
			"." );
		BAlert * sHurra = new BAlert (
			"Sieg!",
			sAnzeige,
			"Yeah!" );
		if ( sHurra != NULL )
			sHurra -> Go ( NULL );
		if ( sAnzeige != NULL )
			delete [] sAnzeige;
	};
};



//
//	Ende
//
// // // // // // // // // // // // //

